#version 140
#extension GL_EXT_gpu_shader4 : enable
//beige vortexMod01.fsh
//https://glslsandbox.com/e#79062.2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
//uniform sampler2D iChannel0;


#define resolution u_WindowSize
#define time          u_Elapsed*0.084
#define pi            3.141592654

mat2 rot(float a){
	float s = sin(a), c = cos(a);
	return mat2(c, s, -s, c);
}

float sdBox(vec3 p, vec3 b){
	vec3 d = abs(p) - b;
	return length(max(d, 0.)) + min(max(max(d.x, d.y), d.z), 0.);
}

float sdSphere(vec3 p, float r){
	return length(p) - r;
}

float map(vec3 p){
	p = mod(p, 2.) - 1.;
	float s = 1.;
	for(int i = 0; i < 5; i++){
		p = abs(p) - .3;
		p.xy *= rot(.6);
		p = abs(p) - .1;
		p.xz *= rot(.28);
		p *= 1.5;
		s *= 1.5;
	}
	return sdBox(p, vec3(.2, .1, .2)) / s;
}

vec3 genNormal(vec3 p){
	vec2 d = vec2(0.01, 0.);
	return normalize(vec3(
		map(p + d.xyy) - map(p - d.xyy),
		map(p + d.yxy) - map(p - d.yxy),
		map(p + d.yyx) - map(p - d.yyx)
		));
}

void main( void ) {

	vec2 p = ( gl_FragCoord.xy * 2. - resolution.xy ) / min(resolution.x, resolution.y);

	vec3 col = vec3(0.0);
	
	vec3 cp = vec3(0., 0., -2. + time);
	vec3 t = vec3(0., 0., 0. + time);
	vec3 f = normalize(t - cp);
	vec3 u = vec3(0., 1., 0.);
	vec3 s = normalize(cross(u, f));
	u = normalize(cross(f, s));
	vec3 rd = normalize(p.x * s + p.y * u + f * (1. - .05 * (1. - dot(p, p))));
	
	float dd, d;
	int k;
	float ac;
	
	for(int i = 0; i < 100; i++){
		dd = map(cp + d * rd);
		if(dd < 0.001){
			break;
		}
		ac += exp(-d * .3);
		k = i;
		d += dd;
	}
	col += float(k) / 200.;
	col += ac * 0.01 * vec3(1., .1, .2);
		
	vec3 ip = cp + d * rd;
	
	if(dd < 0.001){
		vec3 normal = genNormal(ip);
		
		vec3 lightPos = vec3(0., 0., time - .2);
		vec3 lightDir = normalize(vec3(.4, .5, -.5));
		
		float spec = clamp(dot(reflect(rd, normal), normalize(lightPos - ip)), 0., 1.) / pow(length(lightPos - ip), 3.);
		//float spec = clamp(dot(reflect(lightDir, normal), rd), 0., 1.);
		col += spec;
	}
	
    	col = mix(vec3(1.), col, exp(-.1 * d));
	col = pow(col, vec3(0.4545));
	gl_FragColor = vec4(col, 1.0 );

}